
Su_47K =  {
	Name = 'Su-47K',
	DisplayName	= _('Su-47K Berkut'),
    EmptyWeight = "16375", --11300 - unusable fuel 78kg 
	MaxFuelWeight = "10000",
	MaxHeight = "18000",
	MaxSpeed = "2230",
	MaxTakeOffWeight = "34000",
	Picture = "Su-47K.png",
	Rate = "50",
	Shape = "Su-47K",
	WingSpan = 15.16,
    WorldID = 5001,

	HumanCockpit 		= true,
	HumanCockpitPath    = current_mod_path..'/Cockpit/Scripts/',

	shape_table_data 	= 
	{
		{
			file  	 	= 'Su-47K'; --AG --edm file name
			life  	 	= 30; -- lifebar
			vis   	 	= 3; -- visibility gain.
			--desrt    	= 'Su_47_destr'; -- Name of destroyed object edm name
			fire  	 	= { 300, 2}; -- Fire on the ground after destoyed: 300sec 2m
			username	= 'Su-47K';
			index    	=  5001;
			classname   = "lLandPlane";
			positioning = "BYNORMAL";
			drawonmap 	= true;
		},
		--{
		--	name  		= "Su_47K_destr";
		--	file  		= "Su_47K_destr"; --edm name
		--	fire  		= { 240, 2};
		--},
	},
		
	mapclasskey = "P0091000024",
	attribute  			= {wsType_Air, wsType_Airplane, wsType_Fighter, Su_47K, "Multirole fighters", "Refuelable", "Datalink"},
	Categories			= {"{78EFB7A2-FD52-4b57-A6A6-3BF0E1D6555F}", "Interceptor",},
	-------------------------	
		-- Basic stats --
	-------------------------
	--Weight
	    M_empty = 16375, --11000 - unusable fuel 78kg 
		M_nominal	=	22000,
		M_max	=	34000,
		M_fuel_max	=	10000,

		H_max	=	18000, --height
		average_fuel_consumption	=	0.2743,
		CAS_min	=	1.58, --min speed that is shwon in hud
		V_opt	=	450, --cruisespeed
		V_take_off	=	75, --takeoff speed
		V_land	=	70, --landing speed
		has_afteburner	=	true,
		has_speedbrake	=	true,
		radar_can_see_ground	=	true,

		AOA_take_off	=	0.17, -- AoA in take off (for AI)
		stores_number	=	12,
		bank_angle_max	=	60, -- Max bank angle (for AI)
		Ny_min	=	-3, -- Min G (for AI)
		Ny_max	=	12, -- Max G (for AI)
		tand_gear_max	=	0.577, --XX  1.732 FA18 3.73,
		V_max_sea_level	=	1618, -- Max speed at sea level in m/s (for AI)
		V_max_h	=	2230, -- Max speed at max altitude in m/s (for AI)
		tanker_type	=	4,  --
		wing_area	=	61.87, -- wing area in m2, important for FM
		wing_span	=	15.16,
		wing_type = 2, -- 0=FIXED_WING/ 1=VARIABLE_GEOMETRY/ 2=FOLDED_WING/ 3=ARIABLE_GEOMETRY_FOLDED
		thrust_sum_max	=	19005, -- thrust in kgf not kN
		thrust_sum_ab	=	31012, -- thrust in kgf not kN
		Vy_max	=	330, -- Max climb speed in m/s (for AI)
		length	=	22.60,
		height	=	6.30,
		flaps_maneuver	=	2,
		Mach_max	=	1.87, -- Max speed in Mach (for AI)
		range	=	3300, -- Max range in km (for AI)
		RCS	=	0.3, -- Radar Cross Section m2
		Ny_max_e	=	8, -- Max G (for AI)
		detection_range_max	=	250,
		IR_emission_coeff	=	0.77, -- Normal engine -- IR_emission_coeff = 1 is Su-27 without afterburner. It is reference.
		IR_emission_coeff_ab	=	3, -- With afterburner
		engines_count	=	2,
		wing_tip_pos = 	{-1.6,	0.75,	6.8}, 
		--------------------------------------
	         -- SUSPENSION CODE BEGINS --
	    --------------------------------------
		nose_gear_pos 								= {5.75, -1.949, 0},
		nose_gear_amortizer_direct_stroke			= 0,  -- down from nose_gear_pos !!!
		nose_gear_amortizer_reversal_stroke			= 1.517 - 1.794,  -- up 
		nose_gear_amortizer_normal_weight_stroke	= -0.07,-- down from nose_gear_pos
		nose_gear_wheel_diameter					=	0.84,
		--nose_gear_door_close_after_retract			=	false,

		main_gear_pos 							 = {-2.8,-1.8,	1.75},    --{-0.928,-1.789,	1.523},
		main_gear_amortizer_direct_stroke		 = 0, --  down from main_gear_pos !!!
		main_gear_amortizer_reversal_stroke		 = 1.395 - 1.689, --  up 
		main_gear_amortizer_normal_weight_stroke = -0.1,-- down from main_gear_pos
		main_gear_wheel_diameter				 =	0.84,
		--nose_gear_door_close_after_retract			=	false,

		engines_nozzles = 
		{
			[1] = 
			{
				pos = 	{-8.5,	0.69,	-0.675},
				elevation	=	0, --vertical rotation in degree
				diameter	=	0.949,
				exhaust_length_ab	=	8.629,
				exhaust_length_ab_K	=	0.76,
				smokiness_level     = 	0.1,
				azimuth      = 0, -- horizontal rotation in degree
			}, -- end of [1]
			[2] = 
			{
				pos = 	{-8.5,	0.69, 0.645},
				elevation	=	0, --vertical rotation in degree
				diameter	=	0.949,
				exhaust_length_ab	=	8.629,
				exhaust_length_ab_K	=	0.76,
				smokiness_level     = 	0.1,
				azimuth      = 0, -- horizontal rotation in degree
			}, -- end of [2]
		}, -- end of engines_nozzles
		crew_memb1ers = 
		{
			[1] = 
			{
				ejection_seat_name	=	9,
				drop_canopy_name	=	48,
				pos = 	{4.403,	1.209,	0},
			}, -- end of [1]
		}, -- end of crew_members
		
		crew_members = 
		{
			[1] = 
			{
					ejection_seat_name	=	9,
					drop_canopy_name	=	48,
					pos = 	{4.403,	1.209,	0},
					ejection_order 		= 2,
					canopy_arg          = 38, 
					pilot_body_arg 		= 540,
					can_be_playable 	= true,
					ejection_added_speed = {-5,15,0},
					role 				 = "pilot",
					role_display_name    = _("Pilot"),
					--ejection_through_canopy = true, --no openbeta usare mechanimations
			
				g_suit 			   =  2.2,
				bailout_arg = -1, --abilitare su openbeta con mechanimations
			}, -- end of [1]
		}, -- end of crew_members
		
		brakeshute_name	=	4,
		air_refuel_receptacle_pos 	= 	{8.15,	1.58,	-1.15},-- refuel coords -- {+Forward|-Backwards, +UP|-Down, -Left|+Right} {7.8658,	1.05078,	-0.7762}
		
		fires_pos = 
		{
			[1] = 	{-1.36,	-0.185,	0},
			[2] = 	{-0.595,	0.294,	2.66},
			[3] = 	{-1.743,	0.234,	-3.769},
			[4] = 	{-0.82,	0.265,	2.774},
			[5] = 	{-0.82,	0.265,	-2.774},
			[6] = 	{-0.82,	0.255,	4.274},
			[7] = 	{-0.82,	0.255,	-4.274},
			[8] = 	{-4.471,	-0.059,	0.91},
			[9] = 	{-4.471,	-0.059,	-0.91},
			[10] = 	{-0.491,	0.629,	2.03},
			[11] = 	{-0.491,	-0.019,	0},
		}, -- end of fires_pos
		chaff_flare_dispenser = 
		{
			[1] = 
			{
				dir = 	{0,	0.999,	0.052},
				pos = 	{-0.937,	1.645,	-1.726},
			}, -- end of [1]
			[2] = 
			{
				dir = 	{0,	0.999,	-0.052},
				pos = 	{-0.937,	1.645,	1.726},
			}, -- end of [2]
		}, -- end of chaff_flare_dispenser
	--    mechanimations openbeta ok
	passivCounterm = {
			CMDS_Edit = true,
			SingleChargeTotal = 96,
			-- PPR-26
			chaff = {default = 48, increment = 12, chargeSz = 1},
			-- PPI-26
			flare = {default = 48, increment = 12, chargeSz = 1}
        },
        
    mechanimations = {
          Door0 = {
                {Transition = {"Close", "Open"},  Sequence = {
                        {C = {{"Arg", 38, "to", 0.12 * 0.9, "at", 0.6, "sign" , 1}}},
                        {C = {{"Arg", 38, "to", 0.25 * 0.9, "at", 1.0, "sign" , 1}}},
                        {C = {{"Arg", 38, "to", 0.75 * 0.9, "at", 0.3, "sign" , 1}}},
                        {C = {{"Arg", 38, "to", 0.85 * 0.9, "at", 1.0, "sign" , 1}}},
                        {C = {{"Arg", 38, "to", 0.90 * 0.9, "at", 0.5}}},
                        {C = {{"Arg", 38, "to", 0.90 * 0.9, "at", 0.5}}},
                        {C = {{"Arg", 38, "to", 0.90 * 0.9, "at", 0.5}}},
                         }, Flags = {"Reversible"}},
                {Transition = {"Open", "Close"},  Sequence = {
                        {C = {{"Arg", 38, "to", 0.00 * 0.9, "at", 0.6}}},
                        {C = {{"Arg", 38, "to", 0.12 * 0.9, "at", 1.0, "sign" , -1}}},
                        {C = {{"Arg", 38, "to", 0.25 * 0.9, "at", 0.3, "sign" , -1}}},
                        {C = {{"Arg", 38, "to", 0.75 * 0.9, "at", 1.0, "sign" , -1}}},
                        {C = {{"Arg", 38, "to", 0.85 * 0.9, "at", 0.5, "sign" , -1}}},
                        {C = {{"Arg", 38, "to", 0.90 * 0.9, "at", 0.25, "sign" , -1}}},
                        {C = {{"Arg", 38, "to", 0.95 * 0.9, "at", 0.125, "sign" , -1}}},
                         }, Flags = {"Reversible", "StepsBackwards"}},
                {Transition = {"Any", "Bailout"}, Sequence = {{C = {{"JettisonCanopy", 0}}}}},
            },
			FoldableWings = {
				{Transition = {"Retract", "Extend"}, Sequence = {
							{C = {{"Arg", 8, "to", 0.0, "in", 5.0}}},
						}, Flags = {"Reversible"}},
				{Transition = {"Extend", "Retract"}, Sequence = {
							{C = {{"Arg", 8, "to", 1.0, "in", 5.0}}},
						}, Flags = {"Reversible", "StepsBackwards"}},
			},
        },

		LandRWCategories = 
        {
        [1] = 
        {
			Name = "AircraftCarrier",
        },
        [2] = 
        {
            Name = "AircraftCarrier With Catapult",
        }, 
        [3] = 
        {
            Name = "AircraftCarrier With Tramplin",
        }, 
    }, -- end of LandRWCategories
        TakeOffRWCategories = 
        {
        [1] = 
        {
			Name = "AircraftCarrier",
        },
        [2] = 
        {
            Name = "AircraftCarrier With Catapult",
        }, 
        [3] = 
        {
            Name = "AircraftCarrier With Tramplin",
        }, 
    }, -- end of TakeOffRWCategories

	-- add model draw args for network transmitting to this draw_args table (16 limit)
	net_animation = 
	{
          8, -- Fold wings
		 13, -- right LE flap
		 14, -- left LE flap
		 19, -- Right Canard
		 20, -- Left Canard 
		 21, -- Airbrake
		 23, -- Wheel Chock
		 24, -- Intake closer
		 25, -- hoook
		 26, -- Bomb bay doors
		 35, -- drag chute
		 36, -- drag chute
		 37, -- drag chute
	    181, --	Canopy Ext
		190,
		191,
		192,
		274, -- left aux inlet
		275, -- right aux inlet
		327, -- left up gun door
		328, -- right up gun door
		329, 
		350,
		351,
		419, -- right down gun door
		427, -- right down gun door
		470, -- nose strut
		450, -- nose strut
	   2215, -- right thrust v
	   2216, -- left thrust v
	   3322,
	   3480,
	   3481,
	   3482,
	   2016,
	   2015,
	},
	CanopyGeometry = makeAirplaneCanopyGeometry(LOOK_AVERAGE, LOOK_AVERAGE, LOOK_AVERAGE),
	EPLRS = true,
	Sensors = {
		RADAR =  "AN/APG-63"  ,
		IRST  = "OLS-27",
		RWR   = "Abstract RWR",
	},
	Countermeasures = {
	ECM 			= "AN/ALQ-165",
	},	
	Failures = {
			{ id = 'asc', 		label = _('ASC'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'autopilot', label = _('AUTOPILOT'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'hydro',  	label = _('HYDRO'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'l_engine',  label = _('L-ENGINE'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'r_engine',  label = _('R-ENGINE'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'radar',  	label = _('RADAR'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'eos',  		label = _('EOS'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'helmet',  	label = _('HELMET'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			--{ id = 'mlws',  	label = _('MLWS'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'rws',  		label = _('RWS'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'ecm',   	label = _('ECM'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'hud',  		label = _('HUD'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'mfd',  		label = _('MFD'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },		
	},
	HumanRadio	= {
		frequency	= 124.0,
		editable	= true,
		minFrequency	= 118.000,
		maxFrequency	= 399.975,
	    rangeFrequency = {
			{min = 118.0, max = 155.995},
			{min = 225.0, max = 399.975}
		},
		modulation	= MODULATION_AM,
	},
	panelRadio	= {
		[1] = {  
		    name = _("COMM 1: R-800"),
		    range = {
				{min = 30.0, max = 87.995},
				{min = 108.0, max = 173.995},
				{min = 225.0, max = 399.975}
			},
			channels = {
				[1] = { name = _("Channel 1"),		default = 305.0, modulation = _("AM/FM"), connect = true}, -- default
				[2] = { name = _("Channel 2"),		default = 264.0, modulation = _("AM/FM")},	-- min. water : 135.0, 264.0
				[3] = { name = _("Channel 3"),		default = 265.0, modulation = _("AM/FM")},	-- nalchik : 136.0, 265.0
				[4] = { name = _("Channel 4"),		default = 256.0, modulation = _("AM/FM")},	-- sochi : 127.0, 256.0
				[5] = { name = _("Channel 5"),		default = 254.0, modulation = _("AM/FM")},	-- maykop : 125.0, 254.0
				[6] = { name = _("Channel 6"),		default = 250.0, modulation = _("AM/FM")},	-- anapa : 121.0, 250.0
				[7] = { name = _("Channel 7"),		default = 270.0, modulation = _("AM/FM")},	-- beslan : 141.0, 270.0
				[8] = { name = _("Channel 8"),		default = 257.0, modulation = _("AM/FM")},	-- krasnodar-pashk. : 128.0, 257.0
				[9] = { name = _("Channel 9"),		default = 255.0, modulation = _("AM/FM")},	-- gelenjik : 126.0, 255.0
				[10] = { name = _("Channel 10"),	default = 262.0, modulation = _("AM/FM")},	-- kabuleti : 133.0, 262.0
				[11] = { name = _("Channel 11"),	default = 259.0, modulation = _("AM/FM")},	-- gudauta : 130.0, 259.0
				[12] = { name = _("Channel 12"),	default = 268.0, modulation = _("AM/FM")},	-- soginlug : 139.0, 268.0
				[13] = { name = _("Channel 13"),	default = 269.0, modulation = _("AM/FM")},	-- vaziani : 140.0, 269.0
				[14] = { name = _("Channel 14"),	default = 260.0, modulation = _("AM/FM")},	-- batumi : 131.0, 260.0
				[15] = { name = _("Channel 15"),	default = 263.0, modulation = _("AM/FM")},	-- kutaisi : 134.0, 263.0
				[16] = { name = _("Channel 16"),	default = 261.0, modulation = _("AM/FM")},	-- senaki : 132.0, 261.0
				[17] = { name = _("Channel 17"),	default = 267.0, modulation = _("AM/FM")},	-- lochini : 138.0, 267.0
				[18] = { name = _("Channel 18"),	default = 251.0, modulation = _("AM/FM")},	-- krasnodar-center : 122.0, 251.0
				[19] = { name = _("Channel 19"),	default = 253.0, modulation = _("AM/FM")},	-- krymsk : 124.0, 253.0
				[20] = { name = _("Channel 20"),	default = 266.0, modulation = _("AM/FM")},	-- mozdok : 137.0, 266.0
			}
		},
		[2] = {  
		    name = _("COMM 2: R-800"),
		    range = {
				{min = 30.0, max = 87.995},
				{min = 108.0, max = 173.995},
				{min = 225.0, max = 399.975}
			},
			channels = {
				[1] = { name = _("Channel 1"),		default = 305.0, modulation = _("AM/FM"), connect = true}, -- default
				[2] = { name = _("Channel 2"),		default = 264.0, modulation = _("AM/FM")},	-- min. water : 135.0, 264.0
				[3] = { name = _("Channel 3"),		default = 265.0, modulation = _("AM/FM")},	-- nalchik : 136.0, 265.0
				[4] = { name = _("Channel 4"),		default = 256.0, modulation = _("AM/FM")},	-- sochi : 127.0, 256.0
				[5] = { name = _("Channel 5"),		default = 254.0, modulation = _("AM/FM")},	-- maykop : 125.0, 254.0
				[6] = { name = _("Channel 6"),		default = 250.0, modulation = _("AM/FM")},	-- anapa : 121.0, 250.0
				[7] = { name = _("Channel 7"),		default = 270.0, modulation = _("AM/FM")},	-- beslan : 141.0, 270.0
				[8] = { name = _("Channel 8"),		default = 257.0, modulation = _("AM/FM")},	-- krasnodar-pashk. : 128.0, 257.0
				[9] = { name = _("Channel 9"),		default = 255.0, modulation = _("AM/FM")},	-- gelenjik : 126.0, 255.0
				[10] = { name = _("Channel 10"),	default = 262.0, modulation = _("AM/FM")},	-- kabuleti : 133.0, 262.0
				[11] = { name = _("Channel 11"),	default = 259.0, modulation = _("AM/FM")},	-- gudauta : 130.0, 259.0
				[12] = { name = _("Channel 12"),	default = 268.0, modulation = _("AM/FM")},	-- soginlug : 139.0, 268.0
				[13] = { name = _("Channel 13"),	default = 269.0, modulation = _("AM/FM")},	-- vaziani : 140.0, 269.0
				[14] = { name = _("Channel 14"),	default = 260.0, modulation = _("AM/FM")},	-- batumi : 131.0, 260.0
				[15] = { name = _("Channel 15"),	default = 263.0, modulation = _("AM/FM")},	-- kutaisi : 134.0, 263.0
				[16] = { name = _("Channel 16"),	default = 261.0, modulation = _("AM/FM")},	-- senaki : 132.0, 261.0
				[17] = { name = _("Channel 17"),	default = 267.0, modulation = _("AM/FM")},	-- lochini : 138.0, 267.0
				[18] = { name = _("Channel 18"),	default = 251.0, modulation = _("AM/FM")},	-- krasnodar-center : 122.0, 251.0
				[19] = { name = _("Channel 19"),	default = 253.0, modulation = _("AM/FM")},	-- krymsk : 124.0, 253.0
				[20] = { name = _("Channel 20"),	default = 266.0, modulation = _("AM/FM")},	-- mozdok : 137.0, 266.0
			}
		},
	},
	TACAN_AA	= true,
	Guns = {gun_mount("GSh_30_1", { count = 150 },{muzzle_pos = {3.7,   1.3,  -1.18}}),
	},

--	pylons_enumeration = {12, 1, 11, 2, 3, 10, 4, 9, 5, 8, 7, 6}
--  Types: 0=direct,1=delayed, 2=invisibl
	Pylons =     {     
		pylon(1, 0, -6.8, 0.7, -1.86, { DisplayName = "ECM" }, --ECM on the back
            {
                { CLSID = "{44EE8698-89F9-48EE-AF36-5FD31896A82A}" ,},--Sorbciya ECM
            }
        ),                             
		pylon(2, 0, -1.5, 0.65, -6.7, --pylon 1 outside
            {
				DisplayName = "1",
				arg = 214,
				arg_value = 0, 
				connector = "Pylon2",
				use_full_connector_position = true, --if you have connectors in the edm
            },
            {
                 --IR--
				{CLSID = "{682A481F-0CB5-4693-A382-D00DD4A156D7}", attach_point_position = {0.5, 0, 0},arg_value = 1,},-- R-60M
			    { CLSID = "{Su30-R-73L-AA}",arg_value = 1, },  --R-73L
                { CLSID = "{Su30-R-73M-AA}",arg_value = 1,},--R-73M
                { CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",arg_value = 1,}, --R-73
				--Smoke--
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B1}", arg_value = 1, },	--Smoke Generator - red
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B2}", arg_value = 1, },	--Smoke Generator - green
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B3}", arg_value = 1, },	--Smoke Generator - blue
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B4}", arg_value = 1, },	--Smoke Generator - white
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B5}", arg_value = 1, },	--Smoke Generator - yellow
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B6}", arg_value = 1, },	--Smoke Generator - orange
            }
			
        ),
        pylon(3, 0, -1.8, 0.55, -5.72, --pylon 2 outside
            {
				DisplayName = "2",
				arg = 213 ,
				arg_value = 0, 
				connector = "Pylon3",
				use_full_connector_position = true, --if you have connectors in the edm
            },
            {
				--Radar Fox 3--
				{ CLSID = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}" , Type = 0,arg_value = 1,}, 	--R-77
                { CLSID = "{SU30_R771}", Type = 1,arg_value = 1,}, --R-77-1
                { CLSID = "{SU30_R77M}", Type = 1,arg_value = 1,},--R-77M

                --IR Fox 2--
			    --{CLSID = "{682A481F-0CB5-4693-A382-D00DD4A156D7}", attach_point_position = {0.5, 0, 0},arg_value = 1,},-- R-60M
			    { CLSID = "{Su30-R-73L-AA}", arg_value = 1, },  --R-73L
                { CLSID = "{Su30-R-73M-AA}", arg_value = 1,},--R-73M
                { CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}", arg_value = 1,}, --R-73
				{ CLSID = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}", Type = 0, arg_value = 1, },	--R-27ET

				--Radar Fox 1--
				{ CLSID = "{9B25D316-0434-4954-868F-D51DB1A38DF0}" ,attach_point_position = {-0.5, 0, 0}, Type = 0, arg_value = 1,},	--R-27R
                { CLSID = "{88DAC840-9F75-4531-8689-B46E64E42E53}" , Type = 0, arg_value = 1,},	--R-27T
                { CLSID = "{E8069896-8435-4B90-95C0-01A03AE6E400}", Type = 0 ,arg_value = 1,},	--R-27ER
                { CLSID = "{SU30_R27EA}", arg_value = 1,}, --R-27AE

				--Fuel Tank--
				--{CLSID = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}", arg_value = 1,},-- Fuel tank 800L Wing
				--{ CLSID = "{PTB_800_MIG21}" , arg_value = 1,},--fuel tank
			
				--Smoke--
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B1}", arg_value = 1, },	--Smoke Generator - red
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B2}", arg_value = 1, },	--Smoke Generator - green
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B3}", arg_value = 1, },	--Smoke Generator - blue
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B4}", arg_value = 1, },	--Smoke Generator - white
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B5}", arg_value = 1, },	--Smoke Generator - yellow
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B6}", arg_value = 1, },	--Smoke Generator - orange
            }
        ),
        pylon(4, 0,  -2.3, 0.55, -4.3, --pylon 3 outside
            {
				DisplayName = "3",
				arg = 212 ,
				arg_value = 0, 
				connector = "Pylon4",
				use_full_connector_position = true, --if you have connectors in the edm
            },
            {
                --Radar Fox 3--
				{ CLSID = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}" , Type = 0,arg_value = 1,}, 	--R-77
                { CLSID = "{SU30_R771}", Type = 1,arg_value = 1,}, --R-77-1
                { CLSID = "{SU30_R77M}", Type = 1,arg_value = 1,},--R-77M
                --IR Fox 2--
				--{CLSID = "{682A481F-0CB5-4693-A382-D00DD4A156D7}", attach_point_position = {0.5, 0, 0},arg_value = 1,},-- R-60M
			    --{ CLSID = "{Su30-R-73L-AA}", arg_value = 1, },  --R-73L
                --{ CLSID = "{Su30-R-73M-AA}", arg_value = 1,},--R-73M
                -- { CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}", arg_value = 1,}, --R-73
				{ CLSID = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}", Type = 0, arg_value = 1, },	--R-27ET
				--Radar Fox 1--
				{ CLSID = "{9B25D316-0434-4954-868F-D51DB1A38DF0}" ,attach_point_position = {-0.5, 0, 0}, Type = 0, arg_value = 1,},	--R-27R
                { CLSID = "{88DAC840-9F75-4531-8689-B46E64E42E53}" , Type = 0, arg_value = 1,},	--R-27T
                { CLSID = "{E8069896-8435-4B90-95C0-01A03AE6E400}", Type = 0 ,arg_value = 1,},	--R-27ER
                { CLSID = "{SU30_R27EA}", arg_value = 1,}, --R-27AE
				--Fuel Tank--
				{CLSID = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}", arg_value = 1,},-- Fuel tank 800L Wing
				{ CLSID = "{PTB_800_MIG21}" , arg_value = 1,},--fuel tank
				
				--Smoke--
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B1}", arg_value = 1, },	--Smoke Generator - red
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B2}", arg_value = 1, },	--Smoke Generator - green
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B3}", arg_value = 1, },	--Smoke Generator - blue
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B4}", arg_value = 1, },	--Smoke Generator - white
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B5}", arg_value = 1, },	--Smoke Generator - yellow
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B6}", arg_value = 1, },	--Smoke Generator - orange
            }
        ),
		pylon(5,  1,-0.8, 0.45, -0.6975, --pylon 1 inside
            {
				DisplayName = "4",
			    arg_value = 1, 
				FiZ = -1, --clean be default
				use_full_connector_position = true, --if you have connectors in the edm
            },    
		    {
                --Radar Fox 3--
				{ CLSID = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}" , Type = 0,arg_value = 1,}, 	--R-77
                { CLSID = "{SU30_R771}", Type = 1,arg_value = 1,}, --R-77-1
                { CLSID = "{SU30_R77M}", Type = 1,arg_value = 1,},--R-77M
                --IR Fox 2--
				--{CLSID = "{682A481F-0CB5-4693-A382-D00DD4A156D7}", attach_point_position = {0.5, 0, 0},arg_value = 1,},-- R-60M 
			    -- { CLSID = "{Su30-R-73L-AA}", arg_value = 1, },  --R-73L
                -- { CLSID = "{Su30-R-73M-AA}", arg_value = 1,},--R-73M
                -- { CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}", arg_value = 1,}, --R-73
				{ CLSID = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}", Type = 0, arg_value = 1, },	--R-27ET
				--Radar Fox 1--
				{ CLSID = "{9B25D316-0434-4954-868F-D51DB1A38DF0}" , Type = 0, arg_value = 1,},	--R-27R
                { CLSID = "{88DAC840-9F75-4531-8689-B46E64E42E53}" , Type = 0, arg_value = 1,},	--R-27T
                { CLSID = "{E8069896-8435-4B90-95C0-01A03AE6E400}", Type = 0 ,arg_value = 1,},	--R-27ER
                { CLSID = "{SU30_R27EA}", arg_value = 1,}, --R-27AE
				--Fuel Tank--
				--{CLSID = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}", arg_value = 1,},-- Fuel tank 800L Wing
				--{ CLSID = "{PTB_800_MIG21}" , arg_value = 1,},--fuel tank
				
				--Smoke--
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B1}", arg_value = 1, },	--Smoke Generator - red
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B2}", arg_value = 1, },	--Smoke Generator - green
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B3}", arg_value = 1, },	--Smoke Generator - blue
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B4}", arg_value = 1, },	--Smoke Generator - white
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B5}", arg_value = 1, },	--Smoke Generator - yellow
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B6}", arg_value = 1, },	--Smoke Generator - orange
            }
        ),
        pylon(6, 1,-0.8, 0.45, -0.36, --pylon 2 inside
		    {
			   DisplayName = "5",
			   arg_value = 1, 
			   FiZ = -1, --clean be default
			   use_full_connector_position = true, --if you have connectors in the edm
            },
            {
                --Radar Fox 3--
				{ CLSID = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}" , Type = 0,arg_value = 1,}, 	--R-77
                { CLSID = "{SU30_R771}", Type = 1,arg_value = 1,}, --R-77-1
                { CLSID = "{SU30_R77M}", Type = 1,arg_value = 1,},--R-77M
                --IR Fox 2--
				--{CLSID = "{682A481F-0CB5-4693-A382-D00DD4A156D7}", attach_point_position = {0.5, 0, 0},arg_value = 1,},-- R-60M 
			    --{ CLSID = "{Su30-R-73L-AA}", arg_value = 1, },  --R-73L
                --{ CLSID = "{Su30-R-73M-AA}", arg_value = 1,},--R-73M
                --{ CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}", arg_value = 1,}, --R-73
				--{ CLSID = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}", Type = 0, arg_value = 1, },	--R-27ET
				--Radar Fox 1--
				{ CLSID = "{9B25D316-0434-4954-868F-D51DB1A38DF0}" , Type = 0, arg_value = 1,},	--R-27R
                { CLSID = "{88DAC840-9F75-4531-8689-B46E64E42E53}" , Type = 0, arg_value = 1,},	--R-27T
                { CLSID = "{E8069896-8435-4B90-95C0-01A03AE6E400}", Type = 0 ,arg_value = 1,},	--R-27ER
                { CLSID = "{SU30_R27EA}", arg_value = 1,}, --R-27AE
				--Fuel Tank--
				--{CLSID = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}", arg_value = 1,},-- Fuel tank 800L Wing
				--{ CLSID = "{PTB_800_MIG21}" , arg_value = 1,},--fuel tank
				
				--Smoke--
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B1}", arg_value = 1, },	--Smoke Generator - red
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B2}", arg_value = 1, },	--Smoke Generator - green
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B3}", arg_value = 1, },	--Smoke Generator - blue
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B4}", arg_value = 1, },	--Smoke Generator - white
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B5}", arg_value = 1, },	--Smoke Generator - yellow
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B6}", arg_value = 1, },	--Smoke Generator - orange
            }
	    ),
        pylon(7,  1, 2.85, 0.45, -0.22, --pylon 3 inside
		    {
				arg = 26 ,
				DisplayName = "6",
		        arg_value = 1, 
				FiZ = -1, --clean be default
				use_full_connector_position = true, --if you have connectors in the edm
            },
            {
                --IR--
				{ CLSID = "{682A481F-0CB5-4693-A382-D00DD4A156D7}", attach_point_position = {0.5, 0, 0},arg_value = 1,},-- R-60M 
			    { CLSID = "{Su30-R-73L-AA}",arg_value = 1, },  --R-73L
                { CLSID = "{Su30-R-73M-AA}",arg_value = 1,},--R-73M
                { CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",arg_value = 1,}, --R-73
                --Smoke--
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B1}", arg_value = 1, },	--Smoke Generator - red
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B2}", arg_value = 1, },	--Smoke Generator - green
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B3}", arg_value = 1, },	--Smoke Generator - blue
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B4}", arg_value = 1, },	--Smoke Generator - white
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B5}", arg_value = 1, },	--Smoke Generator - yellow
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B6}", arg_value = 1, },	--Smoke Generator - orange
            }
        ),
		pylon(8, 1, 2.85, 0.45, 0.148, --pylon 4 inside
		    {
				DisplayName = "7",
			    arg_value = 1, 
				FiZ = -1, --clean be default
				use_full_connector_position = true, --if you have connectors in the edm
            },
            {
				--IR--
				{ CLSID = "{682A481F-0CB5-4693-A382-D00DD4A156D7}", attach_point_position = {0.5, 0, 0},arg_value = 1,},-- R-60M 
			    { CLSID = "{Su30-R-73L-AA}",arg_value = 1, },  --R-73L
				{ CLSID = "{Su30-R-73M-AA}",arg_value = 1,},--R-73M
				{ CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",arg_value = 1,}, --R-73
				--Smoke--
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B1}", arg_value = 1, },	--Smoke Generator - red
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B2}", arg_value = 1, },	--Smoke Generator - green
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B3}", arg_value = 1, },	--Smoke Generator - blue
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B4}", arg_value = 1, },	--Smoke Generator - white
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B5}", arg_value = 1, },	--Smoke Generator - yellow
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B6}", arg_value = 1, },	--Smoke Generator - orange
				
            }
	    ),
		pylon(9,  1,-0.8, 0.45, 0.284, --pylon 5 inside
		    {
				DisplayName = "8",
			    arg_value = 1, 
				FiZ = -1, --clean be default
				use_full_connector_position = true, --if you have connectors in the edm
            },
            {
				--Radar Fox 3--
				{ CLSID = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}" , Type = 0,arg_value = 1,}, 	--R-77
                { CLSID = "{SU30_R771}", Type = 1,arg_value = 1,}, --R-77-1
                { CLSID = "{SU30_R77M}", Type = 1,arg_value = 1,},--R-77M
                --IR Fox 2--
				--{CLSID = "{682A481F-0CB5-4693-A382-D00DD4A156D7}", attach_point_position = {0.5, 0, 0},arg_value = 1,},-- R-60M 
			    --{ CLSID = "{Su30-R-73L-AA}", arg_value = 1, },  --R-73L
                --{ CLSID = "{Su30-R-73M-AA}", arg_value = 1,},--R-73M
                --{ CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}", arg_value = 1,}, --R-73
				--{ CLSID = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}", Type = 0, arg_value = 1, },	--R-27ET
				--Radar Fox 1--
				{ CLSID = "{9B25D316-0434-4954-868F-D51DB1A38DF0}" , Type = 0, arg_value = 1,},	--R-27R
                { CLSID = "{88DAC840-9F75-4531-8689-B46E64E42E53}" , Type = 0, arg_value = 1,},	--R-27T
                { CLSID = "{E8069896-8435-4B90-95C0-01A03AE6E400}", Type = 0 ,arg_value = 1,},	--R-27ER
                { CLSID = "{SU30_R27EA}", arg_value = 1,}, --R-27AE
				--Fuel Tank--
				--{CLSID = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}", arg_value = 1,},-- Fuel tank 800L Wing
				--{ CLSID = "{PTB_800_MIG21}" , arg_value = 1,},--fuel tank
				
				--Smoke--
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B1}", arg_value = 1, },	--Smoke Generator - red
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B2}", arg_value = 1, },	--Smoke Generator - green
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B3}", arg_value = 1, },	--Smoke Generator - blue
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B4}", arg_value = 1, },	--Smoke Generator - white
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B5}", arg_value = 1, },	--Smoke Generator - yellow
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B6}", arg_value = 1, },	--Smoke Generator - orange
            }
	    ),
		pylon(10,  1,-0.8, 0.45, 0.64, --pylon 6 inside
		    {
				DisplayName = "9",
			    arg_value = 1, 
				FiZ = -1, --clean be default
				use_full_connector_position = true, --if you have connectors in the edm
            },
            {
				--Radar Fox 3--
				{ CLSID = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}" , Type = 0,arg_value = 1,}, 	--R-77
                { CLSID = "{SU30_R771}", Type = 1,arg_value = 1,}, --R-77-1
                { CLSID = "{SU30_R77M}", Type = 1,arg_value = 1,},--R-77M
                --IR Fox 2--
				--{CLSID = "{682A481F-0CB5-4693-A382-D00DD4A156D7}", attach_point_position = {0.5, 0, 0},arg_value = 1,},-- R-60M 
			    --{ CLSID = "{Su30-R-73L-AA}", arg_value = 1, },  --R-73L
                --{ CLSID = "{Su30-R-73M-AA}", arg_value = 1,},--R-73M
                --{ CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}", arg_value = 1,}, --R-73
				{ CLSID = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}", Type = 0, arg_value = 1, },	--R-27ET
				--Radar Fox 1--
				{ CLSID = "{9B25D316-0434-4954-868F-D51DB1A38DF0}" , Type = 0, arg_value = 1,},	--R-27R
                { CLSID = "{88DAC840-9F75-4531-8689-B46E64E42E53}" , Type = 0, arg_value = 1,},	--R-27T
                { CLSID = "{E8069896-8435-4B90-95C0-01A03AE6E400}", Type = 0 ,arg_value = 1,},	--R-27ER
                { CLSID = "{SU30_R27EA}", arg_value = 1,}, --R-27AE
				--Fuel Tank--
				--{CLSID = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}", arg_value = 1,},-- Fuel tank 800L Wing
				--{ CLSID = "{PTB_800_MIG21}" , arg_value = 1,},--fuel tank
				
				--Smoke--
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B1}", arg_value = 1, },	--Smoke Generator - red
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B2}", arg_value = 1, },	--Smoke Generator - green
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B3}", arg_value = 1, },	--Smoke Generator - blue
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B4}", arg_value = 1, },	--Smoke Generator - white
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B5}", arg_value = 1, },	--Smoke Generator - yellow
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B6}", arg_value = 1, },	--Smoke Generator - orange
            }
	    ),
        pylon(11, 0, -2.3, 0.55, 4.2, --pylon 4 outside
            {
				DisplayName = "10",
				arg = 211 ,
				arg_value = 0, 
				connector = "Pylon11",
			    use_full_connector_position = true, --if you have connectors in the edm
            },
            {
				--Radar Fox 3--
				{ CLSID = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}" , Type = 0,arg_value = 1,}, 	--R-77
                { CLSID = "{SU30_R771}", Type = 1,arg_value = 1,}, --R-77-1
                { CLSID = "{SU30_R77M}", Type = 1,arg_value = 1,},--R-77M
                 --IR Fox 2--
				--{CLSID = "{682A481F-0CB5-4693-A382-D00DD4A156D7}", attach_point_position = {0.5, 0, 0},arg_value = 1,},-- R-60M 
			    --{ CLSID = "{Su30-R-73L-AA}", arg_value = 1, },  --R-73L
                --{ CLSID = "{Su30-R-73M-AA}", arg_value = 1,},--R-73M
                --{ CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}", arg_value = 1,}, --R-73
				{ CLSID = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}", Type = 0, arg_value = 1, },	--R-27ET
				--Radar Fox 1--
				{ CLSID = "{9B25D316-0434-4954-868F-D51DB1A38DF0}" ,attach_point_position = {-0.5, 0, 0}, Type = 0, arg_value = 1,},	--R-27R
                { CLSID = "{88DAC840-9F75-4531-8689-B46E64E42E53}" , Type = 0, arg_value = 1,},	--R-27T
                { CLSID = "{E8069896-8435-4B90-95C0-01A03AE6E400}", Type = 0 ,arg_value = 1,},	--R-27ER
                { CLSID = "{SU30_R27EA}", arg_value = 1,}, --R-27AE
				--Fuel Tank--
				{CLSID = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}", arg_value = 1,},-- Fuel tank 800L Wing
				{ CLSID = "{PTB_800_MIG21}" , arg_value = 1,},--fuel tank
				
				--Smoke--
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B1}", arg_value = 1, },	--Smoke Generator - red
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B2}", arg_value = 1, },	--Smoke Generator - green
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B3}", arg_value = 1, },	--Smoke Generator - blue
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B4}", arg_value = 1, },	--Smoke Generator - white
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B5}", arg_value = 1, },	--Smoke Generator - yellow
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B6}", arg_value = 1, },	--Smoke Generator - orange
            }
        ),
		 pylon(12, 0,  -1.8, 0.55, 5.65, --pylon 5 outside
            {
				DisplayName = "11",
				arg = 210,
				arg_value = 0, 
				connector = "Pylon12",
				use_full_connector_position = true, --if you have connectors in the edm
            },
            {
				--Radar Fox 3--
				{ CLSID = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}" , Type = 0,arg_value = 1,}, 	--R-77
                { CLSID = "{SU30_R771}", Type = 1,arg_value = 1,}, --R-77-1
                { CLSID = "{SU30_R77M}", Type = 1,arg_value = 1,},--R-77M
                --IR Fox 2--
				--{CLSID = "{682A481F-0CB5-4693-A382-D00DD4A156D7}", attach_point_position = {0.5, 0, 0},arg_value = 1,},-- R-60M 
			    { CLSID = "{Su30-R-73L-AA}", arg_value = 1, },  --R-73L
                { CLSID = "{Su30-R-73M-AA}", arg_value = 1,},--R-73M
                { CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}", arg_value = 1,}, --R-73
				{ CLSID = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}", Type = 0, arg_value = 1, },	--R-27ET
				--Radar Fox 1--
				{ CLSID = "{9B25D316-0434-4954-868F-D51DB1A38DF0}" ,attach_point_position = {-0.5, 0, 0}, Type = 0, arg_value = 1,},	--R-27R
                { CLSID = "{88DAC840-9F75-4531-8689-B46E64E42E53}" , Type = 0, arg_value = 1,},	--R-27T
                { CLSID = "{E8069896-8435-4B90-95C0-01A03AE6E400}", Type = 0 ,arg_value = 1,},	--R-27ER
                { CLSID = "{SU30_R27EA}", arg_value = 1,}, --R-27AE
				--Fuel Tank--
				--{CLSID = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}", arg_value = 1,},-- Fuel tank 800L Wing
				--{ CLSID = "{PTB_800_MIG21}" , arg_value = 1,},--fuel tank
				
				--Smoke--
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B1}", arg_value = 1, },	--Smoke Generator - red
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B2}", arg_value = 1, },	--Smoke Generator - green
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B3}", arg_value = 1, },	--Smoke Generator - blue
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B4}", arg_value = 1, },	--Smoke Generator - white
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B5}", arg_value = 1, },	--Smoke Generator - yellow
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B6}", arg_value = 1, },	--Smoke Generator - orange
            }
        ),
        pylon(13, 0, -1.5, 0.65, 6.65, --pylon 6 outside
		    {
				DisplayName = "12",
			    arg = 209 ,
				arg_value = 0, 
				connector = "Pylon13",
			    use_full_connector_position = true, --if you have connectors in the edm
		    },
            {
			     --IR--
				{CLSID = "{682A481F-0CB5-4693-A382-D00DD4A156D7}", attach_point_position = {0.5, 0, 0}, arg_value = 1,},-- R-60M 
			    { CLSID = "{Su30-R-73L-AA}",arg_value = 1, },  --R-73L
                { CLSID = "{Su30-R-73M-AA}",arg_value = 1,},--R-73M
                { CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",arg_value = 1,}, --R-73
                 --Smoke--
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B1}", arg_value = 1, },	--Smoke Generator - red
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B2}", arg_value = 1, },	--Smoke Generator - green
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B3}", arg_value = 1, },	--Smoke Generator - blue
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B4}", arg_value = 1, },	--Smoke Generator - white
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B5}", arg_value = 1, },	--Smoke Generator - yellow
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B6}", arg_value = 1, },	--Smoke Generator - orange
            }
        ), 
		pylon(14, 0, -7.3, 0.7, 1.5, { DisplayName = "ECM" }, --ECM in the Back
            {
                { CLSID = "{44EE8698-89F9-48EE-AF36-5FD31896A82A}" ,},--Sorbciya ECM
            }
        ),
		       
},
	
	Tasks = {
        aircraft_task(AFAC),
        aircraft_task(SEAD),
        aircraft_task(AntishipStrike),
        aircraft_task(CAS),
        aircraft_task(PinpointStrike),
        aircraft_task(GroundAttack),
        aircraft_task(RunwayAttack),
		aircraft_task(CAP),
     	aircraft_task(Escort),
        aircraft_task(FighterSweep),
		aircraft_task(Intercept),
		aircraft_task(Reconnaissance),
	    aircraft_task(RunwayAttack),
    },	
	DefaultTask = aircraft_task(CAS),

-- M   - Mach number
			-- Cx0 - Coefficient, drag, profile, of the airplane
			-- Cya - Normal force coefficient of the wing and body of the aircraft in the normal direction to that of flight. Inversely proportional to the available G-loading at any Mach value. (lower the Cya value, higher G available) per 1 degree AOA
			-- B2 - Polar 2nd power coeff
			-- B4 - Polar 4th power coeff
			-- Omxmax - roll rate, rad/s
			-- Aldop - Alfadop Max AOA at current M - departure threshold
			-- Cymax - Coefficient, lift, maximum possible (ignores other calculations if current Cy > Cymax)

			SFM_Data = {
		
				aerodynamics = 
				{
					Cy0	=	0,
					Mzalfa	=	4.355,
					Mzalfadt	=	0.8,
					kjx	=	2.75,
					kjz	=	0.00125,
					Czbe	=	-0.016,
					cx_gear	=	0.032,
					cx_flap	=	0.035,
					cy_flap	=	0.24,
					cx_brk	=	0.06,
					table_data = 
					{
						[1] = 	{0,	0.024,	0.07,	0.075,	0.12,	0.2,	30,	1.2},
						[2] = 	{0.2,	0.024,	0.07,	0.075,	0.12,	0.8,	30,	1.2},
						[3] = 	{0.4,	0.024,	0.07,	0.075,	0.12,	1.8,	30,	1.2},
						[4] = 	{0.6,	0.0239,	0.073,	0.075,	0.12,	2.5,	30,	1.2},
						[5] = 	{0.7,	0.024,	0.076,	0.075,	0.12,	2.634,	28.666666666667,	1.18},
						[6] = 	{0.8,	0.0235,	0.079,	0.075,	0.12,	2.5,	27.333333333333,	1.16},
						[7] = 	{0.9,	0.025,	0.083,	0.075,	0.125,	1.9,	26,	1.14},
						[8] = 	{1,	0.044,	0.085,	0.14,	0.1,	1.43,	24.666666666667,	1.12},
						[9] = 	{1.05,	0.0465,	0.0855,	0.1775,	0.125,	1.047,	24,	1.11},
						[10] = 	{1.1,	0.049,	0.086,	0.215,	0.15,	0.9,	18,	1.1},
						[11] = 	{1.2,	0.049,	0.083,	0.228,	0.17,	0.8,	17,	1.05},
						[12] = 	{1.3,	0.049,	0.077,	0.237,	0.2,	0.7,	16,	1},
						[13] = 	{1.5,	0.0475,	0.062,	0.251,	0.2,	0.7,	13,	0.9},
						[14] = 	{1.7,	0.045166666666667,	0.051333333333333,	0.24366666666667,	0.32,	0.7,	12,	0.7},
						[15] = 	{1.8,	0.044,	0.046,	0.24,	0.38,	0.7,	11.4,	0.64},
						[16] = 	{2,	0.043,	0.039,	0.222,	2.5,	0.7,	10.2,	0.52},
						[17] = 	{2.2,	0.041,	0.034,	0.227,	3.2,	0.7,	9,	0.4},
						[18] = 	{2.5,	0.04,	0.033,	0.25,	4.5,	0.7,	9,	0.4},
						[19] = 	{3.9,	0.035,	0.033,	0.35,	6,	0.7,	9,	0.4},
					}, -- end of table_data
				}, -- end of aerodynamics
				engine = 
				{
					Nmg	=	67.5,--67.5,
					MinRUD	=	0,
					MaxRUD	=	1,
					MaksRUD	=	0.85,
					ForsRUD	=	0.91,
					type	=	"TurboJet",
					hMaxEng	=	19,
					dcx_eng	=	0.0144,
					cemax	=	1.24,
					cefor	=	2.56,
					dpdh_m	=	6600,
					dpdh_f	=	13200,
					table_data = 
					{
						[1] = 	{0,	88000,	141000},
						[2] = 	{0.2,	80000,	143000},
						[3] = 	{0.4,	79000,	150000},
						[4] = 	{0.6,	82000,	165000},
						[5] = 	{0.7,	90000,	177000},
						[6] = 	{0.8,	94000,	193000},
						[7] = 	{0.9,	96000,	200000},
						[8] = 	{1,	100000,	205000},
						[9] = 	{1.1,	100000,	214000},
						[10] = 	{1.2,	98000,	222000},
						[11] = 	{1.3,	100000,	235000},
						[12] = 	{1.5,	98000,	258000},
						[13] = 	{1.8,	94000,	266000},
						[14] = 	{2,	88000,	273000},
						[15] = 	{2.2,	82000,	275000},
						[16] = 	{2.5,	80000,	277000},
						[17] = 	{3.9,	50000,	200000},
					}, -- end of table_data
				}, -- end of engine
			},
	--damage , index meaning see in  Scripts\Aircrafts\_Common\Damage.lua
	
	Damage = {
		[0]  = {critical_damage = 5,  args = {146}}, -- 0 - nose center
		[1]  = {critical_damage = 3,  args = {296}}, -- 1 - nose left
		[2]  = {critical_damage = 3,  args = {297}}, -- 2 - nose right
		[3]  = {critical_damage = 8,  args = { 65}}, -- 3 - cockpit
		[4]  = {critical_damage = 2,  args = {298}}, -- 4 - cabin left
		[5]  = {critical_damage = 2,  args = {301}}, -- 5 - cabin right
													 -- 6 - cabin bottom 
		[7]  = {critical_damage = 2,  args = {249}}, -- 7 - gun
		[8]  = {critical_damage = 2,  args = {265}}, -- 8 - front gear
		[9]  = {critical_damage = 3,  args = {154}}, -- 9 - fuselage left
		[10] = {critical_damage = 3,  args = {153}}, -- 10 - fuselage right
		[11] = {critical_damage = 1,  args = {167}}, -- 11 - engine in left 
		[12] = {critical_damage = 1,  args = {161}}, -- 12 - engine in right 
		[13] = {critical_damage = 2,  args = {169}}, -- 13 - nacelle, left bottom
		[14] = {critical_damage = 2,  args = {163}}, -- 14 - nacelle, right bottom
		[15] = {critical_damage = 2,  args = {267}}, -- 15 - gear left 
		[16] = {critical_damage = 2,  args = {266}}, -- 16 - gear right
		[17] = {critical_damage = 2,  args = {168}}, -- 17 - nacelle, left (left engine out, left ewu)
		[18] = {critical_damage = 2,  args = {162}}, -- 18 - nacelle, right (right engine out, right ewu)
													 -- 19 - airbrake left
		[20] = {critical_damage = 1,  args = {183}}, -- 20 - airbrake right
													 -- 21 - slat out left
													 -- 22 - slat out right
		[23] = {critical_damage = 5,  args = {223}}, -- 23 - wing out left
		[24] = {critical_damage = 5,  args = {213}}, -- 24 - wing out right
													 -- 25 - aileron left 
													 -- 26 - aileron right 
		[27] = {critical_damage = 3,  args = {231}}, -- 27 - slat centre left
		[28] = {critical_damage = 3,  args = {221}}, -- 28 - slat centre right
		[29] = {critical_damage = 6,  args = {200}, deps_cells = {23}}, -- 29 - wing centre left
		[30] = {critical_damage = 6,  args = {214}, deps_cells = {24}}, -- 30 - wing centre right
													 -- 31 - flap out left 
													 -- 32 - flap out right 
													  -- 33 - slat in left 
													 -- 34 - slat in right 
		[35] = {critical_damage = 6,  args = {225}, deps_cells = {23, 29, 27, 37}}, -- 35 - wing in left
		[36] = {critical_damage = 6,  args = {215}, deps_cells = {24, 30, 28, 38}}, -- 36 - wing in right
		[37] = {critical_damage = 2,  args = {228}}, -- 37 - flap in left 
		[38] = {critical_damage = 2,  args = {218}}, -- 38 - flap in right
		[39] = {critical_damage = 2,  args = {244}}, -- 39 - fin top left
		[40] = {critical_damage = 2,  args = {241}}, -- 40 - fin top right
													 -- 41 - fin centre left
													 -- 42 - fin centre right
		[43] = {critical_damage = 2,  args = {243}, deps_cells = {39, 53}}, -- 43 - fin bottom left
		[44] = {critical_damage = 2,  args = {242}, deps_cells = {40, 54}}, -- 44 - fin bottom right
																			-- 45 - stabilizer out left
																			-- 46 - stabilizer out right
																			-- 47 - stabilizer in left
																			-- 48 - stabilizer in right
																			-- 49 - elevator out left
																			-- 50 - elevator out  right
		[51] = {critical_damage = 2,  args = {240}}, -- 51 - elevator in left
		[52] = {critical_damage = 2,  args = {238}}, -- 52 - elevator in right
		[53] = {critical_damage = 2,  args = {248}}, -- 53 - rudder left
		[54] = {critical_damage = 2,  args = {247}}, -- 54 - rudder right
		[55] = {critical_damage = 2,  args = {159}}, -- 55 - tail
													 -- 56 - tail left
													 -- 57 - tail right
		[58] = {critical_damage = 2,  args = {156}}, -- 58 - tail bottom
		[59] = {critical_damage = 2,  args = {148}}, -- 59 - nose bottom
		[82] = {critical_damage = 2,  args = {152}}, -- 82 - fuselage bottom
		[83] = {critical_damage = 3,  args = {134}}, -- 83 - wheel nose                                  
		[84] = {critical_damage = 3,  args = {136}}, -- 84 - wheel left                                  
		[85] = {critical_damage = 3,  args = {135}}, -- 85 - wheel right                              
													 -- 98 - hook
													 -- 100 - tail top
													 -- 101 - flap centre left
													 -- 102 - flap centre right
	-- 137 - custom range starts here (NB: update with new damage cells)
		},
	
	
}
add_aircraft(Su_47K)